class MapEnd expands Trigger;

#exec TEXTURE IMPORT NAME=Trigger_MapEnd FILE=Textures\Trigger_MapEnd.bmp Group=Triggers MIPS=ON

function Touch( actor Other )
{
	local actor A;
	if( IsRelevant( Other ) )
	{
		if ( ReTriggerDelay > 0 )
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
			TriggerTime = Level.TimeSeconds;
		}

		if( Event != '' )
			foreach AllActors( class 'Actor', A, Event )
				A.Trigger( Other, Other.Instigator );

		if ( Other.IsA('Pawn') && (Pawn(Other).SpecialGoal == self) )
			Pawn(Other).SpecialGoal = None;
				
		if( Message != "" )
			Other.Instigator.ClientMessage( Message );

		TriggerObjective();

		if( bTriggerOnceOnly )
			SetCollision(False);
		else if ( RepeatTriggerTime > 0 )
			SetTimer(RepeatTriggerTime, false);
	}
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local actor A;

	if ( bInitiallyActive && (TriggerType == TT_Shoot) && (Damage >= DamageThreshold) && (instigatedBy != None) )
	{
		if ( ReTriggerDelay > 0 )
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
			TriggerTime = Level.TimeSeconds;
		}

		if( Event != '' )
			foreach AllActors( class 'Actor', A, Event )
				A.Trigger( instigatedBy, instigatedBy );

		if( Message != "" )
			instigatedBy.Instigator.ClientMessage( Message );

		if( bTriggerOnceOnly )
			SetCollision(False);

		TriggerObjective();
	
	}
}

function TriggerObjective()
{
local Monsterhunt2game MH;
local PlayerPawn A;

	MH = Monsterhunt2game(Level.Game);
	if (MH != None)
		{
		MH.bFulfilledSpecial = True;
		MH.EndGame("timelimit");
/*
		foreach AllActors(class'PlayerPawn', A)
					{
					A.GotoState('GameEnded');
					}
*/
		}
	else
		log("MonsterEnd - TriggerObjective - MH == None");
}

defaultproperties
{
     bHidden=False
     bInitiallyActive=True
     Texture=Texture'Trigger_MapEnd'
}


